﻿<%@ Page Language="c#" CodePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ import Namespace="Soneta.Types" %>
<%@ import Namespace="Soneta.Tools" %>
<%@ import Namespace="Soneta.Waluty" %>
<%@ import Namespace="Soneta.Kasa" %>
<%@ import Namespace="Soneta.Business.App" %>
<%@ import Namespace="Soneta.Business" %>
<%@ import Namespace="Soneta.CRM" %>
<%@ import Namespace="Soneta.Core" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Wezwanie do zapłaty</title>
		<script runat="server">

            //Jeżeli wydruk używany jest dla instalacji z aktywną licencją 'WINDYKACJA', to poniżej można 
            //wpisać nazwę stanu windykacji dla której poniższy wydruk może być uruchamiany.
            //Jeżeli pole zostanie wypełnione, to próba wydruku dokumentu bez stanu windykacji 
            //lub ze stanem innym niż wprowadzony zakończy się zgłoszeniem błędu.
            static string wymaganyStanWindykacji = "";

            static bool wartośćZOdsetkami = false;
		    
    class WgWaluty {
    
		
		
        class ComparePSP: IComparer 
		{
			public int Compare(object x, object y) 
			{
			    WezwanieDoZaplatyPozycja px = (WezwanieDoZaplatyPozycja)x;
			    WezwanieDoZaplatyPozycja py = (WezwanieDoZaplatyPozycja)y;
			    
			    if (px==null && py==null)
					return 0;
				if (px==null)
					return -1;
				if (py==null)
					return 1;
					
				int cmp = px.DataDokumentu.CompareTo(py.DataDokumentu);
				if (cmp==0)
				    cmp = px.NumerDokumentu.CompareTo(py.NumerDokumentu);
				if (cmp == 0)
					cmp = (px.Platnosc != null ? px.Platnosc.ID : 0).CompareTo(py.Platnosc != null ? py.Platnosc.ID : 0);
				if (cmp == 0)
					cmp = px.Okres.From.CompareTo(py.Okres.From);
				
				return cmp;				
			}
        }

        Currency wartosc = Currency.Zero;
        ArrayList pozycje = new ArrayList();
		
        Hashtable dokumenty = new Hashtable();
		Boolean sorted = true;
    
        public WgWaluty() 
		{
        }
    
		
        public void Add(WezwanieDoZaplatyPozycja pozycja) {
			object key = pozycja.Platnosc;
			if (key==null)
				key = pozycja.NumerDokumentu;
			if (dokumenty[key]==null) {
				dokumenty.Add(key, pozycja);
				if (wartosc==Currency.Zero)
					wartosc = pozycja.Należność;
				else
					wartosc += pozycja.Należność;
            }
			
            pozycje.Add(pozycja);
			sorted = false;
        }
		
		
        public Currency Wartosc {
            get { 
                if (wartośćZOdsetkami && odsetki!=0)
                    return wartosc + odsetki;
                return wartosc;
            }
        }
		
		
        Currency odsetki = Currency.Zero;
        public Currency Odsetki {
            get { return odsetki; }
            set { odsetki = value; }
        }
		
		
        public IEnumerable Pozycje 
		{
            get {
				if (!sorted)
				{
					pozycje.Sort(new ComparePSP());
					sorted = true;
				}
				return pozycje; 
			}
        }
    }
    
    string title;

            void OnContextLoad(Object sender, EventArgs args) {
                WezwanieDoZaplaty dok = (WezwanieDoZaplaty)dc.Get(typeof(WezwanieDoZaplaty));
                if (wymaganyStanWindykacji != "" && (dok.Stan == null || string.Compare(wymaganyStanWindykacji, dok.Stan.Nazwa, true) != 0))
                    throw new RowException(dok, @"Raport dla dokumentu '{0}' nie może zostać wydrukowany. 
Wydruk przygotowany dla dokumentów ze stanem windykacji '{1}'.
Zmień stan windykacji lub wybierz inny wydruk.", dok, wymaganyStanWindykacji);

				DataRepeater1.DataSource = prms.TylkoOryginal ? new object[] { dok } : new object[] { dok, dok };
				title = ReportHeader1.Title;

                KasaModule kasa = KasaModule.GetInstance(dc);
                if (dok.Koszt.Value == 0m)
                    SectionKoszt.Visible = false;


				string faks = dok.Stan != null ? kasa.Config.Windykacje.Faks : kasa.Config.WezwanieDoZapłaty.Faks;
				if (faks != "")
					dlFaks.EditValue = " Kopie dowodów brakujących w zestawieniu wpłat prosimy wysyłać na fax " + faks + ".";

				string osoba = dok.Stan != null ? kasa.Config.Windykacje.Osoba : kasa.Config.WezwanieDoZapłaty.Osoba;
				if (osoba != "")
				{
					string tel = dok.Stan != null ? kasa.Config.Windykacje.Telefon : kasa.Config.WezwanieDoZapłaty.Telefon;
					dlKontakt.EditValue = " W przypadku pytań lub wątpliwości prosimy o kontakt z " + osoba + ", tel " + tel + ".";
				}


                Hashtable ht = new Hashtable();
                foreach (WezwanieDoZaplatyPozycja pozycja in dok.Pozycje) {
                    string symbol = pozycja.Należność.Symbol;
                    WgWaluty wgw = (WgWaluty)ht[symbol];
                    if (wgw == null)
                        ht.Add(symbol, wgw = new WgWaluty());
                    wgw.Add(pozycja);
                }

                DataRepeater2.DataSource = ht.Values;
				IdFooter.Caption = String.Format("&nbsp;Data wydruku: {0}<BR>&nbsp;Operator: {1}", Date.Today, prms.Context.Session.Login.Operator.Name);

				if (prms.OdsetkiInTotal)
				{
					wartośćZOdsetkami = true;
					IdSummaryText.EditValue = "Do zapłaty z tytułu nieuregulowalnych należności i odsetek:";
				}
				else
				{
					wartośćZOdsetkami = false;
					IdSummaryText.EditValue = "Do zapłaty z tytułu nieuregulowalnych należności:";
				}
								
				if (prms.InfoOdsetki)
				{
					colRazem.Visible = prms.ShowSummary;
				}
				else
				{
					colStopa.Visible = false;
					colOdsetki.Visible = false;
					colRazem.Visible = false;
				}

                if (!kasa.Config.WezwanieDoZapłaty.Szczegółowe) {
                    colStopa.Caption = "&nbsp;";
                }

				if (prms.KontoWirtualne && dok.RachunekWirtualny != null)
				{
					ScWirtualny.Visible = true;
					IdBankWirt.Visible = dok.RachunekWirtualny.EwidencjaSP.Rachunek.Bank != null;
					IdSwiftWirt.Visible = !String.IsNullOrEmpty(dok.RachunekWirtualny.EwidencjaSP.Rachunek.SWIFT);
				}
				else if (dok.RachunekBankowy != null)
				{
					ScRegularny.Visible = true;
					IdBankReg.Visible = dok.RachunekBankowy.Rachunek.Bank != null;
					IdSwiftReg.Visible = !String.IsNullOrEmpty(dok.RachunekBankowy.Rachunek.SWIFT);
				}
				else
					throw new ApplicationException(String.Format("Dla wezwania {0} nie udało się ustalić rachunku bankowego jaki ma zostać użyty na wydruku.", dok));

				if (dok.MaPozycjeNieprzeterminowane && dok.MaPozycjePrzeterminowane)
					LabelParagrafId.EditValue = "458 i 476";
				else if (dok.MaPozycjePrzeterminowane)
					LabelParagrafId.EditValue = "476";
				else if (dok.MaPozycjeNieprzeterminowane)
					LabelParagrafId.EditValue = "458";

                var kh = dok.Podmiot as Kontrahent;
                if (kh != null && prms.AdresKorespondencyjny && !String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy + kh.AdresDoKorespondencji.Linia1 + kh.AdresDoKorespondencji.Linia2))
                {
                    LblAdPodmiot.EditValue = String.IsNullOrWhiteSpace(kh.KorespondencjaNazwaFirmy) ? dok.Podmiot.NazwaFormatowana : kh.KorespondencjaNazwaFirmy;
                    LblAdAdresLinia1.EditValue = kh.AdresDoKorespondencji.Linia1;
                    LblAdAdresLinia2.EditValue = kh.AdresDoKorespondencji.Linia2;
                    ScAdresat.Visible = true;
                }
                LblPodmiot.EditValue = dok.Podmiot.NazwaFormatowana;
                LblAdresLinia1.EditValue = dok.Podmiot.Adres.Linia1;
                LblAdresLinia2.EditValue = dok.Podmiot.Adres.Linia2;
                EuVAT.EditValue = dok.Podmiot.EuVAT == "" ? "" : "NIP: " + dok.Podmiot.EuVAT;
			}
    
            bool first = true;

            void OnBeforeRow(Object sender, EventArgs args) {
                if (first) {
                    first = false;
                    ReportHeader1.Title = title + "ORYGINAŁ";
                }
                else
                    ReportHeader1.Title = title + "KOPIA";
            }

			
            protected void Grid1_AfterRender(object sender, EventArgs e)
			{
				if (prms.InfoOdsetki)
				{
					WgWaluty wgw = (WgWaluty)DataRepeater2.CurrentRow;
					wgw.Odsetki = (Currency)colOdsetki.TotalValue;
				}
            }


			private Boolean IsFirstRow(WezwanieDoZaplatyPozycja poz)
			{
				WgWaluty ds = (WgWaluty)DataRepeater2.CurrentRow;
				foreach (WezwanieDoZaplatyPozycja srcPos in ds.Pozycje)
				{
					if ((poz.Platnosc != null && poz.Platnosc == srcPos.Platnosc) || (poz.Platnosc == null && poz.DataDokumentu == srcPos.DataDokumentu && poz.NumerDokumentu == srcPos.NumerDokumentu))
						return poz == srcPos;
				}

				System.Diagnostics.Debug.Assert(false);				
				return false;
			}
			

			private void Grid1_BeforeRow (object sender , RowEventArgs e)
			{
				WezwanieDoZaplatyPozycja poz = (WezwanieDoZaplatyPozycja) e.Row;
				IdOkres.EditValue = poz.Okres.IsNull ? "(nie naliczano odsetek)" : poz.Okres.ToString();

				Currency naleznosc = IsFirstRow(poz) ? poz.Należność : Currency.Empty;

				colNaleznosc.EditValue = naleznosc;
				
				if(prms.InfoOdsetki)
					colOdsetki.EditValue = poz.Odsetki;
				if (prms.ShowSummary)
					colRazem.EditValue = naleznosc.AddExt(poz.Odsetki);
			}


        

			private Params prms;

			[Context]
			public Params Prms
			{ set { prms = value; } }


			public class Params : ContextBase
			{
				private Boolean tylkoOryginal = false;
				private bool kontoWirtualne = false;
				private Boolean infoOdsetki = true;
				private Boolean showSummary = false;
				private Boolean odsetkiInTotal = false;


				public Params(Context ctx) :
					base(ctx)
				{ }


				[Priority(10)]
				[Caption("Tylko oryginał")]
				public Boolean TylkoOryginal
				{
					get { return tylkoOryginal; }
					set { tylkoOryginal = value; }
				}
				

				[Priority(15)]
				[Caption("Rachunek wirtualny")]
				public bool KontoWirtualne
				{
					get { return kontoWirtualne; }
					set { kontoWirtualne = value; }
				}


				[Priority(20)]
				[Caption("Informacja o odsetkach")]
				public Boolean InfoOdsetki
				{
					get { return infoOdsetki; }
					set
					{
						if (!(infoOdsetki = value))
						{
							showSummary = false;
							odsetkiInTotal = false;
						}
						OnChanged(EventArgs.Empty);
					}
				}


				[Priority(30)]
				[Caption("Pokaż kolumnę 'Razem'")]
				public Boolean ShowSummary
				{
					get { return showSummary; }
					set { showSummary = value; }
				}


				[Priority(40)]
				[Caption("Dolicz odsetki do kwoty")]
				public Boolean OdsetkiInTotal
				{
					get { return odsetkiInTotal; }
					set { odsetkiInTotal = value; }
				}

                [Priority(99)]
                [Caption("Adres korespondencyjny")]
                public Boolean AdresKorespondencyjny { get; set; }

				public Boolean IsReadOnlyShowSummary()
				{ return !infoOdsetki; }

				public Boolean IsReadOnlyOdsetkiInTotal()
				{ return !infoOdsetki; }
			}		
		            
		</script>
		<meta http-equiv="Content-Type" content="text/html; charset=utf-8">
		<meta content="Microsoft Visual Studio 7.0" name="GENERATOR">
		<meta content="C#" name="CODE_LANGUAGE">
		<meta content="JavaScript" name="vs_defaultClientScript">
		<meta content="http://schemas.microsoft.com/intellisense/ie5" name="vs_targetSchema">
	</HEAD>
	<body>
		<form id="WezwanieDoZapłaty" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" TypeName="Soneta.Kasa.WezwanieDoZaplaty,Soneta.Kasa" oncontextload="OnContextLoad"></ea:datacontext>
			<ea:datarepeater id="DataRepeater1" runat="server" Height="0px" Width="100%" RowTypeName="Soneta.Kasa.WezwanieDoZaplaty,Soneta.Kasa" onbeforerow="OnBeforeRow">
			<ea:SectionMarker id="SectionMarker1" runat="server"></ea:SectionMarker>
			<ea:PageBreak id="PageBreak1" runat="server" BreakFirstTimes="False" ResetPageCounter="true"></ea:PageBreak>
			<cc1:ReportHeader id="ReportHeader1" title="Wezwanie do zapłaty|</strong>Numer: <strong>{0}|</strong>Data:<strong> {1}|" runat="server" DataMember0="Numer" DataMember1="Data"></cc1:ReportHeader>

				<em>Konto bankowe:</em> <br/>
				<ea:Section runat="server" ID="ScWirtualny" Visible="false">
					<ea:DataLabel id="IdBankWirt" runat="server" Format="{0}<br/>" DataMember="RachunekWirtualny.EwidencjaSP.Rachunek.Bank.Nazwa"></ea:DataLabel>
					<ea:DataLabel id="IdSwiftWirt" runat="server" Format="SWIFT: {0}<br/>" DataMember="RachunekWirtualny.EwidencjaSP.Rachunek.SWIFT"></ea:DataLabel>
					<ea:DataLabel id="DataLabel7" runat="server" DataMember="RachunekWirtualny.Numer"></ea:DataLabel>
				</ea:Section>
				<ea:Section runat="server" ID="ScRegularny" Visible="false">
					<ea:DataLabel id="IdBankReg" runat="server" Format="{0}<br/>" DataMember="RachunekBankowy.Rachunek.Bank.Nazwa"></ea:DataLabel> 
					<ea:DataLabel id="IdSwiftReg" runat="server" Format="SWIFT: {0}<br/>" DataMember="RachunekBankowy.Rachunek.SWIFT"></ea:DataLabel>
					<ea:DataLabel id="DataLabel12" runat="server" DataMember="RachunekBankowy.Rachunek.Numer"></ea:DataLabel>
				</ea:Section>
                <table style="width: 100%; border:hidden">
                    <tbody>
                        <tr>
                            <td valign="top" width="50%">
		                        <p>
			                        <em>Odbiorca:</em><br />
			                        <ea:DataLabel ID="LblPodmiot" runat="server" /><br />
			                        <ea:DataLabel ID="LblAdresLinia1" runat="server" /><br />
			                        <ea:DataLabel ID="LblAdresLinia2" runat="server" /><br />
                                    <ea:DataLabel id="EuVAT" runat="server"></ea:DataLabel>
		                        </p>
                            </td>
                            <td valign="top" width="50%">
                                <ea:Section runat="server" ID="ScAdresat" Visible="false">
                                <p>
			                        <em>Adres korespondencyjny:</em><br />
			                        <ea:DataLabel ID="LblAdPodmiot" runat="server" /><br />
			                        <ea:DataLabel ID="LblAdAdresLinia1" runat="server" /><br />
			                        <ea:DataLabel ID="LblAdAdresLinia2" runat="server" /><br />
		                        </p>
                                </ea:Section>
                            </td>
                        </tr>
                    </tbody>
                </table>
					
				<P><B>Szanowni Państwo,</B>
					<BR>
					Stosownie do art. <ea:DataLabel runat="server" ID="LabelParagrafId" Bold="false" /> Kodeksu Cywilnego – wzywamy do dobrowolnego dokonania zapłaty należności aktualnych na dzień
					<ea:DataLabel id="DataLabel4" runat="server" DataMember="Data"></ea:DataLabel>:
				</P>
	<ea:DataRepeater id="DataRepeater2" runat="server" Width="100%">
					<ea:SectionMarker id="SectionMarker2" runat="server"></ea:SectionMarker>
						<ea:Grid id="Grid1" runat="server" RowTypeName="Soneta.Kasa.WezwanieDoZaplatyPozycja,Soneta.Kasa"
							DataMember="Pozycje" CellBorder="None" RowsInRow="2" OnAfterRender="Grid1_AfterRender" OnBeforeRow="Grid1_BeforeRow">
							<Columns>
								<ea:GridColumn DataMember="NumerDokumentu" Caption="Dokument" runat="server"></ea:GridColumn>
								<ea:GridColumn ID="colOpis" ColSpan="3" BottomBorder="Single"  DataMember="Opis" Caption="Opis" NoWrap="True" runat="server"></ea:GridColumn>
								<ea:GridColumn Width="12" Align="Center" DataMember="DataDokumentu" Caption="Data" runat="server"></ea:GridColumn>
								<ea:GridColumn Width="11" Align="Right" DataMember="Kwota" Format="{0:n}" runat="server"></ea:GridColumn>
								<ea:GridColumn Width="11" Align="Center" DataMember="TerminZaplaty" Caption="Termin" runat="server"></ea:GridColumn>
								<ea:GridColumn Width="20" Align="Center" ID="IdOkres" BottomBorder="Single" ColSpan="2" Caption="Okres" runat="server" Total="Info" ></ea:GridColumn>
								<ea:GridColumn Width="9" Align="Center" DataMember="Zwloka" Caption="Zwłoka" HideZero="True" runat="server"></ea:GridColumn>
								<ea:GridColumn Align="Right" Width="13" Total="Sum" RowSpan="2" BottomBorder="Single"  Caption="Pozostaje" Format="{0:n}" ID="colNaleznosc" runat="server"></ea:GridColumn>
								<ea:GridColumn ID="colStopa" Width="11" Align="Right" DataMember="Procent" Caption="Stopa" HideZero="True" runat="server"></ea:GridColumn>
								<ea:GridColumn Align="Right"  Width="11" Total="Sum" Caption="Odsetki" BottomBorder="Single" Format="{0:n}" ID="colOdsetki" HideZero="True" runat="server"></ea:GridColumn>
								<ea:GridColumn Align="Right"  Width="13" Total="Sum" Caption="Razem" BottomBorder="Single" Format="{0:n}" ID="colRazem" HideZero="True" RowSpan="2" runat="server"></ea:GridColumn>
							</Columns>
						</ea:Grid>
						
						<div style="margin-top:5mm;text-align:right;">
							<ea:datalabel runat="server" Id="IdSummaryText" />&nbsp;<ea:DataLabel id="DataLabel5" runat="server" DataMember="Wartosc" Format="{0:u}" /><br />
							Słownie:&nbsp;<ea:DataLabel id="DataLabel10" runat="server" DataMember="Wartosc" Format="{0:t}" Bold="False" />
						</div>
					
					<ea:SectionMarker id="SectionMarker3" runat="server" SectionType="Footer"></ea:SectionMarker>
				</ea:DataRepeater>
				<ea:Section ID="SectionKoszt" runat="server">
				<TABLE id="Table2" cellSpacing="0" cellPadding="0" width="90%">
					<TR>
						<TD align="right" width="60%" colSpan="1" rowSpan="1">Koszty przygotowania i przesłania niniejszego wezwania wynoszą dodatkowo:</TD>
						<TD align="right" width="2%">&nbsp;</TD>
						<TD align="right">
							<ea:DataLabel id="DataLabel6" runat="server" DataMember="Koszt" Format="{0:u}"></ea:DataLabel></TD>
					</TR>
					<TR>
						<TD align="right"><FONT size="2"><EM>Słownie:</EM></FONT></TD>
						<TD align="right" width="2%">&nbsp;</TD>
						<TD align="right"><FONT size="2"><EM>
									<ea:DataLabel id="DataLabel11" runat="server" DataMember="Koszt" Format="{0:t}" Bold="False"></ea:DataLabel></EM></FONT></TD>
					</TR>
				</TABLE>
				</ea:Section>								
<p class="MsoBodyText">W przypadku nieprzekazania w całości w/w kwoty na nasze konto w terminie do 
					3 dni od daty otrzymania niniejszego wezwania, sprawę skierujemy zgodnie z 
					wewnętrznymi procedurami na drogę postępowania windykacyjnego.
				</p>
<p class="MsoBodyText">Jeżeli opłacili Państwo wymienione należności przed otrzymaniem niniejszego 
					listu, przepraszamy za niniejsze wezwanie i prosimy o kontakt w celu 
					wyjaśnienia sprawy.
					<ea:DataLabel ID="dlFaks" runat="server" Bold="False"></ea:DataLabel>
					<ea:DataLabel ID="dlKontakt" runat="server" Bold="False"></ea:DataLabel></p>
<cc1:ReportFooter ID="ReportFooter1" runat="server" Height="105px" TheEnd="False">
					<subtitles>
						<cc1:FooterSubtitle runat="server" ID="IdFooter" SubtitleType="CenterText" Caption="Operator" Width="50"></cc1:FooterSubtitle>
						<cc1:FooterSubtitle Caption="Data i podpis osoby uprawnionej do wystawienia wezwania" Width="50"></cc1:FooterSubtitle>
					</subtitles>
				</cc1:ReportFooter>
<ea:SectionMarker ID="SectionMarker4" runat="server" SectionType="Footer"></ea:SectionMarker>
            </ea:datarepeater>
		</form>
	</body>
</HTML>
